////////////////////////////////////////////////////////////////////////////////////
///                                                                              ///
///          BIBLIOTHÈQUE DE SAGESSE ET DE RÉFLEXION par JÉRÉMY MAURICE          ///
///                                                                              ///
////////////////////////////////////////////////////////////////////////////////////
///                                                                              ///
///    SE PLACER DEVANT LE SONAR POUR ACTIVER LE LECTURE DES EXTRAITS AUDIOS     ///
///       SORTIR DE LA ZONE DE DÉTECTION POUR METTRE EN PAUSE LES EXTRAITS       ///
///    REVENIR DEVANT LE SONAR POUR POURSUIVRE LA LECTURE AUDIO DES EXTRAITS     ///
///                                                                              ///
////////////////////////////////////////////////////////////////////////////////////

/// L'ENSEMBLE A ÉTÉ RÉALISÉ SUR PROCESSING VERSION 3.0.1 : À TÉLÉCHARGER SUR MAC \\\

/// Librairies à télécharger et à importer pour le fonctionnement du code \\\
import cc.arduino.*;        /// Pour les fonctionnalités arduino \\\
import processing.serial.*; /// Pour le port de communication entre l'arduino et lE Mac \\\
import ddf.minim.*;         /// Pour faire jouer le son \\\

/// Variables utilisées
int           gMax            = 7;                /// Quantité d'extraits audio modifiable en fonction \\\
int[]         gTabRandom      = new int[gMax];     /// Maximum d'extraits audios dans le tableau \\\
int           gMaxTabRandom   = gTabRandom.length; /// Longueur du tableau \\\
int           gidx            = 0;                 /// L'extrait audio en train de jouer \\\
int           gCountFilm      = 0;                 /// Nombre d'extraits audio joués \\\
int           delaiHorsLimite = 1000;              /// Temps avant la pause une fois hors limite (1000 = 1 seconde) \\\                                                       
int           distancePouces  = 1;                 /// Valeur par défaut en pouces \\\                                              
int           distanceCm      = 1;                 /// Valeur par défaut en cm \\\
long          i               = 0;                 /// Variable \\\
boolean       gbPause         = false;             /// Boolean pour la pause : faux par défaut \\\
String[]      gFilms          = new String[gMax];  /// Nom de l'extrait audio \\\
String        data;                                /// Données de la distance reçues du sonar \\\
Serial        gMyPort;                             /// Port de connexion arduino \\\
AudioPlayer[] gTabFilmPlayer;                      /// Lecteur audio utilisé ici pour le code en processing \\\

/// Nommer les fonctions qui seront utilisées plus bas \\\
void setup() 
  { frameRate(1);
    background(0);
    initArduinoSettings();
    initTabRandom(); 
    initTabFilm();
    construireTabRandom();
    construireEtJouerFilmsRandom(); }

/// Énumération de tous les ports possible des ports Apple \\\
void initArduinoSettings() 
  { gMyPort = new Serial(this,Serial.list()[2],9600); 
    println(Serial.list()[2]);
    gMyPort.bufferUntil(10); }

/// Initialiser le tableau aléatoire séquentielement \\\
void initTabRandom() 
  { for(int i = 0; i < gMaxTabRandom; i++)
    { gTabRandom[i] = i; } }

/// Films qui seront joués : gFilms[gMax] (gMax : comprend entre 0 et le nombre total de film -1) = associé aux noms des fichiers audios \\\
void initTabFilm() 
  { gFilms[0] =                  "AVATAR.mp3";
    gFilms[1] =    "BLADE-RUNNER-2049-03.mp3";
    gFilms[2] =                 "DUNE-01.mp3";
    gFilms[3] = "GHOST-IN-THE-SHELL-I-01.mp3";
    gFilms[4] =                "STARGATE.mp3";
    gFilms[5] =               "WEST-WING.mp3";
    gFilms[6] =                 "X-FILES.mp3"; }

/// Construire le tableau aléatoire \\\
void construireTabRandom()  
{ int lidx = 0;
  int temp = 0;
    for(int i = 0; i < gMaxTabRandom; i++) 
      { lidx             = (int)random(0,gMax - 1);
        temp             = gTabRandom[i];
        gTabRandom[i]    = gTabRandom[lidx]; 
        gTabRandom[lidx] = temp; } }

/// Chercher l'extrait audio dans le tableau random et le faire jouer \\\
void construireEtJouerFilmsRandom()
  { String sFileFilm; 
    Minim mini     = new Minim(this); 
    gTabFilmPlayer = new AudioPlayer[gMaxTabRandom]; 
      for(int i = 0; i < gMaxTabRandom; i++)
        { sFileFilm = gFilms[gTabRandom[i]]; 
          gTabFilmPlayer[i] = mini.loadFile(sFileFilm); }
          gCountFilm     = 1; 
          distancePouces = 50; 
          gTabFilmPlayer[gidx].play();
          println(gCountFilm + " / " + gMax + " : " + gFilms[gTabRandom[gidx]]);
            if(gTabFilmPlayer[gidx].isPlaying())
              { gbPause = false; } }

/// Continuer la lecture des extraits audio, faire la pause ou recommencer la lecture audio aléatoire \\\
void draw()
  { if(gbPause == false) 
    { if(gTabFilmPlayer[gidx].isPlaying())
      { }
        else if(gTabFilmPlayer[gidx].isPlaying() == false) 
          { println("\n");
            gCountFilm = gCountFilm + 1; 
            gidx       = gidx + 1;
              if(gidx == gMax) 
                { println("Nouvelle lecture");
                  initTabRandom(); 
                  construireTabRandom(); 
                  gidx = 0; 
                  construireEtJouerFilmsRandom(); }
                    else 
                      { gTabFilmPlayer[gidx].play();
                        println(gCountFilm + " / " + gMax + " : " + gFilms[gTabRandom[gidx]]); } } 
                          else
                            { } } }

/// Détection par arduino pour le sonar \\\
void serialEvent(Serial gMyPort)
  { data = gMyPort.readStringUntil(10);
    if(data != null) 
      { if((i % 10) == 0) 
        { data = trim(data); 
          data = data.replace("in","");
          data = data.replace("cm","");
          data = trim(data);
          int values[] = int(split(data,","));
            if(values.length > 0) 
              { distancePouces = values[0];
                distanceCm     = values[1]; } 
                  if(distancePouces > 0 && distancePouces <= 48) 
                    { gTabFilmPlayer[gidx].play(); 
                      println(distancePouces + " pouces : En train de jouer"); 
                      gbPause = false; }
                        else { delay(delaiHorsLimite); 
                                 if(gTabFilmPlayer[gidx].isPlaying()) 
                                   { gTabFilmPlayer[gidx].pause();
                                     gbPause = true;
                                     println(distancePouces + " pouces : En pause"); } } } 
                                       i = i + 1; } }